
/************************************************************************
 *
 * \file: aautoDemoIControllerCallbacks.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Prototype
 *
 * \author: D. Girnus / ADIT/SW1/Brunel / dgirnus@de.adit-jv.com
 *
 * \copyright (c) 2013 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/


#ifndef AAUTOT_AAUTO_DEMO_ICONTROLLER_CALLBACKS_H
#define AAUTOT_AAUTO_DEMO_ICONTROLLER_CALLBACKS_H


/* *************  includes  ************* */

#include <string>
#include <adit_typedef.h>
#include <sys_time_adit.h>
#include <pthread_adit.h>
#include <adit_logging.h>
/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/IControllerCallbacks.h>
#include <aauto/util/Transport.h>

namespace adit { namespace aauto {

/* This class includes a general set of IControllerCallbacks that must be set up for the GAL receiver */
class AautoDemoIControllerCallbacks : public IControllerCallbacks, public ITransportCallbacks {
public:
    AautoDemoIControllerCallbacks(::shared_ptr<GalReceiver> galReceiver, const std::string inSerial) : mGalReceiver(galReceiver), mSerial(inSerial) { mRecvByeByeResponse = false; }

    /* drops the reference to GalReceiver object */
    void releaseReceiver() { mGalReceiver = nullptr; }

    void serviceDiscoveryRequestCallback(const std::string& smallIcon, const std::string& mediumIcon,
            const std::string& largeIcon, const std::string& label, const std::string& deviceName);
    void unrecoverableErrorCallback(MessageStatus err);
    void pingRequestCallback(int64_t timestamp, bool bugReport);
    void pingResponseCallback(int64_t timestamp);
    void navigationFocusCallback(NavFocusType focusType);
    void byeByeRequestCallback(ByeByeReason reason);
    void byeByeResponseCallback();
    void voiceSessionNotificationCallback(VoiceSessionStatus status);
    virtual void audioFocusRequestCallback(AudioFocusRequestType request);

    bool getRecvByeByeResponse(void) { return mRecvByeByeResponse; }

    void notifyStatusCallback(GalReceiverTransportStatus inStatus);
private:
    ::shared_ptr<GalReceiver> mGalReceiver;
    bool mRecvByeByeResponse;
    std::string mSerial;
};


} } /* namespace adit { namespace aauto { */

#endif /* AAUTOT_AAUTO_DEMO_ICONTROLLER_CALLBACKS_H */
